package com.ejie.ab04b.webservice.client.documentowebservice;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;

/**
 * @author Administrador
 *         <p>
 *         Java class for definicionCol complex type.
 * 
 *         <p>
 *         The following schema fragment specifies the expected content
 *         contained within this class.
 * 
 *         <pre>
 * &lt;complexType name="definicionCol">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="alineacion" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="ancho" type="{http://www.w3.org/2001/XMLSchema}int" minOccurs="0"/>
 *         &lt;element name="fuente" type="{http://www.w3.org/2001/XMLSchema}int" minOccurs="0"/>
 *         &lt;element name="key" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="padding" type="{http://www.w3.org/2001/XMLSchema}int" minOccurs="0"/>
 *         &lt;element name="titulo" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="total" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="pdf" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 *         </pre>
 * 
 * 
 */
@XmlAccessorType(value = XmlAccessType.FIELD)
@XmlType(namespace = "definicionCol", propOrder = { "alineacion", "ancho", "fuente",
		"key", "padding", "titulo", "total", "pdf", "maestro" })
public class DefinicionCol {

	private String titulo; // String, nombre que saldrá como título de la
							// columna
	private String key; // String, nombre de la columna en la base de datos
						// IMPORTANTE QUE SE LLAME IGUAL (la consulta a la base
						// de datos se hace con estas keys)
	private Integer ancho; // Tamaño relativo de columa. Pasar Integer como
							// parámetro. Divide el documento entre la suma de
							// los anchos de columna y los asigna, por lo que
							// son tamaños relativos. Si por ejemplo le pasamos
							// a una columna 1, a otra 2 y a otra 4, la primera
							// ocupará 1/7 parte del documento, la segunda 2/7
							// partes y la tercera 4/7 partes.
	private AlineacionCol alineacion; // Opciones para pasar como parámetro:
	// "centrado", "izquierda", "derecha".
	private Integer fuente; // Tamaño de letra de la columna en points (pt).
	private Integer padding; // Tamaño de relleno de la columna en points (pt).
	private boolean total; // Sumatorio del total de la columna.
	private boolean pdf; // Variable para controlar las columnas introducidas en
							// el pdf
	private boolean maestro; // Indica si la columna es una columna "maestro",
								// el listado se dividirá
								// en base a esa columna en varias subtablas;
								// sólo se aplica a salida en PDF

	/**
								 * Instantiates a new definicion col.
								 */
	public DefinicionCol() {

	}

	/**
	 * Instantiates a new definicion col.
	 *
	 * @param titulo            String
	 * @param key            String
	 * @param ancho            Integer
	 * @param alineacion            AlineacionCol
	 * @param fuente            Integer
	 * @param padding            Integer
	 * @param total            boolean
	 * @param pdf            boolean
	 */
	public DefinicionCol(String titulo, String key, Integer ancho,
			AlineacionCol alineacion, Integer fuente, Integer padding,
			boolean total, boolean pdf) {
		super();
		this.titulo = titulo;
		this.key = key;
		this.ancho = ancho;
		this.alineacion = alineacion;
		this.fuente = fuente;
		this.padding = padding;
		this.total = total;
		this.pdf = pdf;
		this.maestro = false;
	}

	/**
	 * Instantiates a new definicion col.
	 *
	 * @param titulo            String
	 * @param key            String
	 * @param ancho            Integer
	 * @param alineacion            AlineacionCol
	 * @param fuente            Integer
	 * @param padding            Integer
	 * @param total            boolean
	 * @param pdf            boolean
	 * @param maestro            boolean
	 */
	public DefinicionCol(String titulo, String key, Integer ancho,
			AlineacionCol alineacion, Integer fuente, Integer padding,
			boolean total, boolean pdf, boolean maestro) {
		super();
		this.titulo = titulo;
		this.key = key;
		this.ancho = ancho;
		this.alineacion = alineacion;
		this.fuente = fuente;
		this.padding = padding;
		this.total = total;
		this.pdf = pdf;
		this.maestro = maestro;
	}

	/**
	 * Gets the titulo.
	 *
	 * @return the titulo
	 */
	public String getTitulo() {
		return this.titulo;
	}

	/**
	 * Sets the titulo.
	 *
	 * @param titulo            the titulo to set
	 */
	public void setTitulo(String titulo) {
		this.titulo = titulo;
	}

	/**
	 * Gets the key.
	 *
	 * @return the key
	 */
	public String getKey() {
		return this.key;
	}

	/**
	 * Sets the key.
	 *
	 * @param key            the key to set
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * Gets the ancho.
	 *
	 * @return the ancho
	 */
	public Integer getAncho() {
		return this.ancho;
	}

	/**
	 * Sets the ancho.
	 *
	 * @param ancho            the ancho to set
	 */
	public void setAncho(Integer ancho) {
		this.ancho = ancho;
	}

	/**
	 * Gets the alineacion.
	 *
	 * @return the alineacion
	 */
	public AlineacionCol getAlineacion() {
		return this.alineacion;
	}

	/**
	 * Sets the alineacion.
	 *
	 * @param alineacion            the alineacion to set
	 */
	public void setAlineacion(AlineacionCol alineacion) {
		this.alineacion = alineacion;
	}

	/**
	 * Gets the fuente.
	 *
	 * @return the fuente
	 */
	public Integer getFuente() {
		return this.fuente;
	}

	/**
	 * Sets the fuente.
	 *
	 * @param fuente            the fuente to set
	 */
	public void setFuente(Integer fuente) {
		this.fuente = fuente;
	}

	/**
	 * Gets the padding.
	 *
	 * @return the padding
	 */
	public Integer getPadding() {
		return this.padding;
	}

	/**
	 * Sets the padding.
	 *
	 * @param padding            the padding to set
	 */
	public void setPadding(Integer padding) {
		this.padding = padding;
	}

	/**
	 * Gets the total.
	 *
	 * @return the padding
	 */
	public boolean getTotal() {
		return this.total;
	}

	/**
	 * Sets the total.
	 *
	 * @param total            the total to set
	 */
	public void setTotal(boolean total) {
		this.total = total;
	}

	/**
	 * Gets the pdf.
	 *
	 * @return the pdf
	 */
	public boolean getPdf() {
		return this.pdf;
	}

	/**
	 * Sets the pdf.
	 *
	 * @param pdf            the pdf to set
	 */
	public void setPdf(boolean pdf) {
		this.pdf = pdf;
	}

	/**
	 * Gets the maestro.
	 *
	 * @return the maestro
	 */
	public boolean getMaestro() {
		return this.maestro;
	}

	/**
	 * Sets the maestro.
	 *
	 * @param maestro            the maestro to set
	 */
	public void setMaestro(boolean maestro) {
		this.maestro = maestro;
	}
}
